; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

#include "..\..\..\version.h"

#define UNINSTKEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\{" + APPID + "}_is1"

#ifdef ALPHA
  #define APPVER 		Str(MAJOR) + "." + Str(MINOR) + "." + Str(VERSION) + "a"
#elif defined BETA
  #define APPVER 		Str(MAJOR) + "." + Str(MINOR) + "." + Str(VERSION) + "b"
#elif defined GAMMA
  #define APPVER 		Str(MAJOR) + "." + Str(MINOR) + "." + Str(VERSION) + "c"
#elif defined DELTA
  #define APPVER 		Str(MAJOR) + "." + Str(MINOR) + "." + Str(VERSION) + "d"
#else
  #define APPVER 		Str(MAJOR) + "." + Str(MINOR) + "." + Str(VERSION)
#endif
#define APPPATH   Str(MAJOR) + "." + Str(MINOR)

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{{#APPID}}
AppName={#APPNAME}
AppVerName={#APPNAME} {#APPVER}
AppVersion={#APPVER}
AppPublisher={#COMPANY}
AppPublisherURL={#WEBSITE}
AppSupportURL={#WEBSITE}
AppUpdatesURL={#WEBSITE}
DefaultDirName={pf}\{#COMPANY}\{#APPNAME} {#APPPATH}
DefaultGroupName={#APPNAME}

UninstallDisplayIcon=..\..\common\setup\icons\classic-uninstall.ico

;ndert das Symbol der Setup.exe; das funktioniert aber nur unter NT-Betriebssystemen.
SetupIconFile=..\setup\icons\{#ICON}

AllowNoIcons=yes
OutputBaseFilename={#APPNAME} Setup {#APPVER}
Compression=lzma
SolidCompression=yes
PrivilegesRequired=poweruser

[Languages]
Name: en; MessagesFile: compiler:Default.isl; \
LicenseFile: ..\setup\License-EN.txt
Name: de; MessagesFile: compiler:Languages\German.isl; \
LicenseFile: ..\setup\License-DE.txt

[CustomMessages]
de.InfoUnins=Programm deinstalieren?
en.InfoUnins=Remove Application?

de.InfoUninsText=Programm ist bereits vorhanden
en.InfoUninsText=The Application already exist

de.InfoUninsQue={#APPNAME} ist bereits in Version %1.%2 vorhanden. Wie mchten Sie fortfahren?
en.InfoUninsQue={#APPNAME} already exist in version %1.%2. How do you want to continue?

de.InfoUninsOption1=Programm entfernen
en.InfoUninsOption1=Remove program

de.InfoUninsOption2=Programm beibehalten und Setup verlassen
en.InfoUninsOption2=Program maintained and leave setup

de.DriverInstall=Treiber Installation
en.DriverInstall=Driver Installation

de.DriverInstallText=Installation des Gertetreibers.
en.DriverInstallText=Installation of the device driver.

de.DriverInstallDesc=Nach der Installation der {#APPNAME} kann nun der der Treiber fr die Gerte der {#COMPANY} installiert werden. Wurde der Treiber bereits installiert, muss er nicht erneut installiert werden. %n%nSoll der Gertetreiber der {#COMPANY} Gerte installiert werden?
en.DriverInstallDesc=After the installation of the {#APPNAME} the driver for the {#COMPANY} devices can be installed. If the driver was already installed, it should not be installed again. %n%nShould the device driver for {#COMPANY} devices also be installed?

de.DriverInstallFinishedDesc=Der Gertetreiber wurde erfolgreich installiert. %n%nSollte Windows nach der Installation trotzdem nach dem Treiber fragen, knnen Sie den Treiber automatisch installieren lassen oder direkt im Unterverzeichnis %n%n    %1\driver %n%nfinden.
en.DriverInstallFinishedDesc=The driver was successfully installed on the PC. %n%nIf Windows should ask for a device driver, you can now let Windows install the driver automatically or you can direct select the driver in the subdirectory %n%n    %1\driver".

de.DriverInstallOption1=Treiber installieren
en.DriverInstallOption1=Install driver

de.DriverInstallOption2=Treiber nicht installieren
en.DriverInstallOption2=Do not install driver

[Tasks]
Name: desktopicon; Description: {cm:CreateDesktopIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked
Name: quicklaunchicon; Description: {cm:CreateQuickLaunchIcon}; GroupDescription: {cm:AdditionalIcons}; Flags: unchecked

[Files]
;Source: "Programm-Name rel oder abs." DestDir: {app}; Flags: ignoreversion
Source: ..\setup\License-DE.txt; DestDir: {app}\license; Languages: de
Source: ..\setup\License-EN.txt; DestDir: {app}\license; Languages: en

Source: ..\setup\icons\*.ico; DestDir: {app}\Icons; Flags: ignoreversion
Source: ..\build\release\{#EXECUTABLE}.exe; DestDir: {app}; Flags: ignoreversion
Source: ..\..\common\depends\*.*; DestDir: {app}; Flags: recursesubdirs ignoreversion
Source: ..\driver\*.*; DestDir: {app}\driver; Flags: ignoreversion
Source: ..\..\common\driver\*.*; DestDir: {app}\driver; Flags: ignoreversion
Source: ..\..\common\license\*.*; DestDir: {app}\license; Flags: ignoreversion
Source: ..\..\common\Images\PUR\*.*; DestDir: {commonappdata}\{#COMPANY}\FirmwareRepository; Flags: comparetimestamp recursesubdirs uninsneveruninstall
Source: ..\..\common\Images\BL\*.*; DestDir: {commonappdata}\{#COMPANY}\BootloaderRepository; Flags: comparetimestamp recursesubdirs uninsneveruninstall
Source: ..\..\common\sounds\*.*; DestDir: {commonappdata}\{#COMPANY}\SoundRepository; Flags: comparetimestamp recursesubdirs uninsneveruninstall

[Dirs]


[Icons]
//Verknpfung im Startmen: 
Name: {group}\{#APPNAME}; Filename: {app}\{#EXECUTABLE}.exe; WorkingDir: {app}; IconFilename: {app}\Icons\{#ICON}
Name: {group}\{cm:UninstallProgram,{#APPNAME}}; Filename: {uninstallexe}; IconFilename: {app}\Icons\classic-uninstall.ico
//Desktop Verknfung: 
Name: {commondesktop}\{#APPNAME}; Filename: {app}\{#EXECUTABLE}.exe; WorkingDir: {app}; IconFilename: {app}\Icons\{#ICON}; Tasks: desktopicon
//Schnellstart Verknpfung: 
Name: {userappdata}\Microsoft\Internet Explorer\Quick Launch\{#APPNAME}; Filename: {app}\{#EXECUTABLE}.exe; WorkingDir: {app}; IconFilename: {app}\Icons\{#ICON}; Tasks: quicklaunchicon

[Run]
;Filename: "{app}\Programm-EXE"; Description: {cm:LaunchProgram,{#APPNAME}}; Flags: nowait postinstall skipifsilent


;Hier knnen Dateien aufgezhlt werden die der Unistaller zuszlich entfernen soll
[UninstallDelete]
;Lscht alle Ordner und Dateien im Insatllationsverzeichnis bei der Deinstallation
Type: files; Name: {app}
Type: files; Name: {app}\Icons
Type: files; Name: {app}\driver
Type: files; Name: {app}\license
Type: files; Name: {app}\sqldrivers
Type: files; Name: {app}\imageformats

;Hinzufgen von Registry-Eintrgen
[Registry]
;Root: HKLM; Subkey: "Software\Ihre Firma"; Flags: uninsdeletekeyifempty
;Root: HKLM; Subkey: "Software\Ihre Firma\Ihre Anwendung"; Flags: uninsdeletekey;
;Root: HKLM; Subkey: "Software\Ihre Firma\Ihre Anwendung"; ValueName: "Path"; ValueData: "{app}"; ValueType: string

[Code]
//------------------------------------------------------------------------------------------------------------------------------------------------------
//Globale Variablen
var
  LegacyUninstallPage: TInputOptionWizardPage;
  s_unistallPath: string;
  unsinstall_pageId: integer;

  DriverInstallPage: TInputOptionWizardPage;
  driverinstall_pageId: integer;


//------------------------------------------------------------------------------------------------------------------------------------------------------
//Prft ob Unistaller.exe schon vorhanden ist.
function DoesUnistallerExist: boolean;
begin
	// den Wert aus der Registry holen, ...
	Result := (RegQueryStringValue(HKLM,'{#UNINSTKEY}','InstallLocation',s_unistallPath)) and (FileExists(s_unistallPath + 'unins000.exe'));
end;
//------------------------------------------------------------------------------------------------------------------------------------------------------



//------------------------------------------------------------------------------------------------------------------------------------------------------
//Bietet die Optionsseite an, wenn das Programm bereits installiert ist.
procedure InitializeWizard;
var
 c_majorV: cardinal;
 c_minorV: cardinal;
begin
 	DriverInstallPage := CreateInputOptionPage(wpInstalling,CustomMessage('DriverInstall'),CustomMessage('DriverInstallText'), CustomMessage('DriverInstallDesc'), true, false);
	DriverInstallPage.Add(CustomMessage('DriverInstallOption1'));
	DriverInstallPage.Add(CustomMessage('DriverInstallOption2'));
	DriverInstallPage.Values[0] := true;
	DriverInstallPage.Values[1] := false;
	driverinstall_pageId := DriverInstallPage.ID;

   if DoesUnistallerExist() then
		begin
		RegQueryDWordValue(HKLM,'{#UNINSTKEY}','MajorVersion', c_majorV);
		RegQueryDWordValue(HKLM,'{#UNINSTKEY}','MinorVersion', c_minorV);
		LegacyUninstallPage := CreateInputOptionPage(wpWelcome,CustomMessage('InfoUnins'),CustomMessage('InfoUninsText'),FmtMessage(CustomMessage('InfoUninsQue'), [IntToStr(c_majorV),IntToStr(c_minorV)]), true, false);
		LegacyUninstallPage.Add(CustomMessage('InfoUninsOption1'));
		LegacyUninstallPage.Add(CustomMessage('InfoUninsOption2'));
		LegacyUninstallPage.Values[0] := true;
		unsinstall_pageId := LegacyUninstallPage.ID;

		// If there was a version before, do not install driver
		DriverInstallPage.Values[0] := false;
		DriverInstallPage.Values[1] := true;
	end else begin
    end;
end;
//------------------------------------------------------------------------------------------------------------------------------------------------------



//------------------------------------------------------------------------------------------------------------------------------------------------------
function NextButtonClick(CurPageID: integer): boolean;
var
 ResultCode : integer;
begin
Result := true;
	if(CurPageID = unsinstall_pageId) then
	begin
		if LegacyUninstallPage.SelectedValueIndex = 1 then
		begin
			Wizardform.close();
			Result := false;
		end	else begin
			Exec(ExpandConstant(s_unistallPath + 'unins000.exe'), '', '', SW_SHOW, ewWaitUntilTerminated, ResultCode);
			Result := true;
		end;

	end;

	if(CurPageID = driverinstall_pageId) then
	begin
		if DriverInstallPage.SelectedValueIndex = 0 then
		begin
      if IsWin64 then
      begin
        Exec(ExpandConstant('{app}\driver\Setup x64.exe'), '', '', SW_SHOW, ewWaitUntilTerminated, ResultCode);
      end else begin
        Exec(ExpandConstant('{app}\driver\Setup x86.exe'), '', '', SW_SHOW, ewWaitUntilTerminated, ResultCode);
      end;
			CreateOutputMsgPage(driverinstall_pageId, CustomMessage('DriverInstall'), CustomMessage('DriverInstallText'), FmtMessage(CustomMessage('DriverInstallFinishedDesc'), [ExpandConstant('{app}')]));
		end;
	end;
end;
//------------------------------------------------------------------------------------------------------------------------------------------------------
